/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8281.DeviceView;

import ibm.nways.jdm.common.OID;
import ibm.nways.jdm8281.DeviceView.AtmConnector;
import ibm.nways.jdm8281.DeviceView.AuiPort;
import ibm.nways.jdm8281.DeviceView.AuiPortInv;
import ibm.nways.jdm8281.DeviceView.Chassis8281Integrated;
import ibm.nways.jdm8281.DeviceView.Chassis8281Standalone;
import ibm.nways.jdm8281.DeviceView.ChassisLike;
import ibm.nways.jdm8281.DeviceView.ChassisUnknown;
import ibm.nways.jdm8281.DeviceView.ConnectorLike;
import ibm.nways.jdm8281.DeviceView.FactoryLike;
import ibm.nways.jdm8281.DeviceView.OptionalAtmCard;
import ibm.nways.jdm8281.DeviceView.OptionalCardLike;
import ibm.nways.jdm8281.DeviceView.OptionalPortCard;
import ibm.nways.jdm8281.DeviceView.Port;
import ibm.nways.jdm8281.DeviceView.PortInv;
import ibm.nways.jdm8281.DeviceView.ResetButton;
import ibm.nways.jdm8281.DeviceView.ResetButtonInv;
import ibm.nways.jdm8281.DeviceView.TtyConnector;
import ibm.nways.jdm8281.DeviceView.TtyConnectorInv;
import java.io.Serializable;

public class Factory
implements FactoryLike {
    private static final FactoryLike instance = new Factory();

    public static FactoryLike getInstance() {
        return instance;
    }

    public ChassisLike createChassis(Serializable serializable) {
        if (serializable instanceof OID) {
            String string = serializable.toString();
            if (string.equals("1.3.6.1.4.1.2.6.28")) {
                return new Chassis8281Standalone();
            }
            if (string.equals("1.3.6.1.4.1.2.6.28.9.1")) {
                return new Chassis8281Integrated();
            }
        }
        return new ChassisUnknown();
    }

    public ConnectorLike createResetButton() {
        return new ResetButton();
    }

    public ConnectorLike createResetButtonInv() {
        return new ResetButtonInv();
    }

    public ConnectorLike createTty() {
        return new TtyConnector();
    }

    public ConnectorLike createTtyInv() {
        return new TtyConnectorInv();
    }

    public ConnectorLike createPort(int n) {
        return new Port(n);
    }

    public ConnectorLike createPortInv(int n) {
        return new PortInv(n);
    }

    public ConnectorLike createAuiPort(int n) {
        return new AuiPort(n);
    }

    public ConnectorLike createAuiPortInv(int n) {
        return new AuiPortInv(n);
    }

    public ConnectorLike createAtm() {
        return new AtmConnector();
    }

    public OptionalCardLike createOptionalPortCard() {
        return new OptionalPortCard();
    }

    public OptionalCardLike createOptionalAtmCard() {
        return new OptionalAtmCard();
    }
}

